local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// linked to
	self.LinkedClass = nil;
	
	// list layout.
	self.Layout = CtlListLayout_class:create( self );
	self.Layout:SetSpacing( 2 );

	// create the header.
	self.Header = CtlHeader_class:create( self.Layout:GetHandle() );
	self.Header:SetPos( 4, 4 );
	self.Header:SetSize( 128, 32 );
	self.Header:SetTitle( "Rotation" );
	self.Layout:AddItem( self.Header );
	
	// create the body.
	self.Body = CtlBody_class:create( self.Layout:GetHandle() );
	self.Body:SetPos( 4, 4 );
	self.Body:SetSize( 128, 96 );
	self.Layout:AddItem( self.Body );
	
	// create pitch
	self.Pitch = CtlRotationGizmo_class:create( self.Body:GetHandle() );
	self.Pitch:SetText( "Pitch" );
	self.Pitch:SetColor( Color( 255, 128, 128, 128 ) );
	self.Pitch:SetConVar( "vmf_rotation_p" );
	
	// create yaw
	self.Yaw = CtlRotationGizmo_class:create( self.Body:GetHandle() );
	self.Yaw:SetText( "Yaw" );
	self.Yaw:SetColor( Color( 128, 255, 128, 128 ) );
	self.Yaw:SetConVar( "vmf_rotation_y" );
	
	// create roll
	self.Roll = CtlRotationGizmo_class:create( self.Body:GetHandle() );
	self.Roll:SetText( "Roll" );
	self.Roll:SetColor( Color( 128, 128, 255, 128 ) );
	self.Roll:SetConVar( "vmf_rotation_r" );
	
end

// size contents


// perform layout
function PANEL:PerformLayout( )
	// width/height
	local width, height = self:GetSize();
	
	// calculate the size of the gizmos.
	local size = ( width - 8 ) * 0.3;

	// size the body.
	self.Body:SetSize( width, size + 8 );
	
	
	// set pitch position.
	self.Pitch:SetPos( 10, 4 );
	self.Pitch:SetSize( size, size );
	
	// set yaw position
	self.Yaw:SetPos( 14 + size, 4 );
	self.Yaw:SetSize( size, size );
	
	// set roll position.
	self.Roll:SetPos( 18 + size * 2, 4 );
	self.Roll:SetSize( size, size );
	
	
	// position the layout.
	self.Layout:SetPos( 0, 0 );
	self.Layout:SetSize( width, height );

	// lets go ahead and force a layout update.
	local newheight = self.Layout:Update();
	
	// set our size
	self:SetSize( width, newheight );
	
end


// draw
function PANEL:Paint( )
	//
	return true;
	
end

// register
vgui.Register( "ctl_rotation_element", PANEL, "Panel" );




// create app framework control.
CtlRotationElement_class 	= Control_class:create( nil, false, "ctl_rotation_element" );

